/*	ccreat.c	1.9	83/05/13	*/
#include <stdio.h>
#include "cpmio.h"
#include "cpmfio.h"

/************************************************************************
 * NAME:	cpm_file_creat()
 *
 * DESCR:	Create a new CPM file with the given name.
 *
 * ARGS:	
 *
 * RETURNS:	NULL if the file can't be created, or alrady exists.
 *		a C_FILE * is returned otherwise.
 *
 * NOTES:	
 ************************************************************************/
C_FILE *
cpm_file_creat(struct cpmfs *cpmfs, char *name, char *ext, int flag)
{

	int	i, index;
	C_FILE	*fptr;
	char	*malloc();

	if (cpm_searchdir(cpmfs,name, ext) != -1) {
	    return(NULL);	/* file already exists	*/
	}

	if ((index = cpm_creext(cpmfs,-1)) < 0) {
	    return (NULL);	/* no space for new file	*/
	}

	/* find free slot for file descriptor */
	for (i = 0, fptr=cpmfs->c_iob; i < cpmfs->numfiles; i++,fptr++) {
		if (!(fptr->c_flag)) 
			break;
	}
	if (i == cpmfs->numfiles) {
	    return (NULL);	/* no space for file buffer	*/
	}

	/*
	 * Free file descriptor slot found, initialize and allocate buffer
	 * memory 
	 */
	if ((fptr->c_buf=malloc(cpmfs->blksiz)) == NULL) {
	    return(NULL);	/* no space for file buffer	*/
	}
	fptr->c_dirp = cpmfs->dirbuf+index;
	if ((i = cpm_alloc(cpmfs)) == '\0') {
	    return (NULL);	/* no alloc blocks left		*/
	}
	if (cpmfs->use16bitptrs) {
		fptr->c_dirp->pointers[0] = i & 0xff;
		fptr->c_dirp->pointers[1] = (i >> 8) & 0xff;
	} else
		fptr->c_dirp->pointers[0] = i;
	fptr->cpmfs = cpmfs;
	fptr->c_dirp->status = '\0';
	fptr->c_dirp->extno  = '\0';
	fptr->c_dirp->notused[0]  = '\0';
	fptr->c_dirp->notused[1]  = '\0';
	strncpy(fptr->c_dirp->name, name, 8);
	strncpy(fptr->c_dirp->ext, ext, 3);
	fptr->c_dirp->blkcnt = '\0';
	fptr->c_blk = 0;
	fptr->c_base = fptr->c_buf;
	fptr->c_flag = WRITE | flag;
	fptr->c_ext = index;
	fptr->c_seccnt = 0;
	fptr->c_cnt = cpmfs->blksiz;
	fptr->c_extno = 0;
	return (fptr);
}
